<?php

namespace Tests\Feature;

use App\Facades\Feature;
use App\Facades\Settings;
use App\Models\FilterIndex;
use App\Modules\PlaceholderImages\ImaginStudio;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Http;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\Crm\Models\Form;
use Mtc\Crm\Models\FormQuestion;
use Mtc\Crm\Models\FormSection;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\Media;
use Mtc\MercuryDataModels\MediaUse;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\SeoDefault;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Mtc\MercuryDataModels\VehicleOffer;
use Mtc\MercuryDataModels\VehicleTrim;
use Tests\TenantTestCase;
use Tests\TestCase;

class NewCarControllerDealerNumberTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testCarShowsDealershipNumber()
    {
        $this->withoutExceptionHandling();
        $dealership1 = Dealership::factory()->create([
            'contact_no' => '123123',
        ]);
        $dealership2 = Dealership::factory()->create([
            'contact_no' => null
        ]);
        $offer = NewCar::factory()->create(['published' => true]);
        $offer1 = NewCar::factory()->create(['published' => true, 'dealership_id' => $dealership1]);
        $offer2 = NewCar::factory()->create(['published' => true, 'dealership_id' => $dealership2]);

        $response = $this->asTenant(tenant())
            ->getJson(route('new-cars.show', $offer));
        $response->assertStatus(200);
        $this->assertNull($response->json('contact_number'));

        $response = $this->asTenant(tenant())
            ->getJson(route('new-cars.show', $offer1));
        $response->assertStatus(200);
        $this->assertIsArray($response->json('contact_number'));
        $this->assertArrayHasKey('number', $response->json('contact_number'));
        $this->assertArrayHasKey('display', $response->json('contact_number'));
        $this->assertStringContainsString('123123', $response->json('contact_number.number'));

        $response = $this->asTenant(tenant())
            ->getJson(route('new-cars.show', $offer2));
        $response->assertStatus(200);
        $this->assertNull($response->json('contact_number'));
    }
}
