<?php

namespace App\Repositories;

use App\Contracts\NewsletterProvider;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;

class NewsletterRepository
{
    /**
     * NewsletterRepository constructor
     *
     * @param NewsletterProvider $provider
     */
    public function __construct(private NewsletterProvider $provider)
    {
        //
    }

    /**
     * Check if user already is signed up
     *
     * @param string $email
     * @return bool
     */
    public function checkIfExists(string $email)
    {
        try {
            return $this->provider->checkIfExists($email);
        } catch (\Exception $exception) {
            Log::error('Failed to check newsletter subscription', [
                'error' => $exception->getMessage(),
                'email' => $exception,
            ]);
            return false;
        }
    }

    /**
     * Sing up email to newsletter
     *
     * @param string $email
     * @param array $additional_params
     * @return bool
     */
    public function signUp(string $email, array $additional_params = [])
    {
        try {
            return $this->provider->signUp($email, $additional_params);
        } catch (\Exception $exception) {
            Log::error('Failed to sign up email to newsletter', [
                'error' => $exception->getMessage(),
                'email' => $exception,
            ]);
            return false;
        }
    }
}
