<?php

namespace App\Modules\Payment;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Checkout\Contracts\PayableContract;
use Mtc\Checkout\Contracts\PayableFactoryContract;
use Mtc\VehicleReservations\ReservationRepository;

class ReservationFactory implements PayableFactoryContract
{
    public function __construct(private readonly ReservationRepository $repository)
    {
        //
    }

    public function create(Request $request): PayableContract
    {
        switch ($request->input('type')) {
            case 'reservation':
                return $this->repository->create($request->input());
        }
        throw new \Exception("Unsupported Payment Object");
    }
}
