<?php

namespace App\Http\Resources;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\VehicleTrim;

class VehicleTrimListResource extends JsonResource
{
    public static $wrap = '';

    public function toArray($request)
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $this->resource->through(fn(VehicleTrim $vehicleTrim) => $this->map($vehicleTrim));
        } else {
            $this->resource = $this->resource->map(fn(VehicleTrim $vehicleTrim) => $this->map($vehicleTrim));
        }
        return parent::toArray($request);
    }

    protected function map(VehicleTrim $vehicleTrim): array
    {
        return [
            'name' => $vehicleTrim->name,
            'full_price' => $vehicleTrim->full_price,
            'cap_id' => $vehicleTrim->cap_id,
        ];
    }
}
