<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Log;

class UiArticleBanner extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $image = $this->resource->subContent
            ->where('slug', 'image')
            ->first()
            ->mediaUses
            ->first();

        return [
            'src' => $image?->getUrl('full-width-banner'),
            'alt' => $image?->alt_text,
            'title' => $image?->title,
            'caption' => $image?->caption,
        ];
    }
}
