<?php

namespace App\Http\Resources;

use App\BookingRepository;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServicePackageResponse extends JsonResource
{
    public static $wrap = '';
    private BookingRepository $repository;

    public function withRepository(BookingRepository $repository): self
    {
        $this->repository = $repository;
        return $this;
    }
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'booking' => new BookingResource($this->resource),
            'availability' => $this->repository->getAvailability(
                $request->input('month'),
                $request->input('year'),
                $this->resource->location_id
            ),
        ];
    }
}
