<?php

namespace App\Http\Requests;

use App\Facades\Feature;
use Illuminate\Foundation\Http\FormRequest;

class ServiceBookingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Feature::isEnabled('service-booking');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'booking_id' => 'required',
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => [
                'required',
                'email',
            ],
            'phone_number' => 'required',
        ];
    }
}
