<?php

namespace App\Http\Controllers;

use App\Facades\LeaseVehicleFilter;
use App\Facades\StockAndOfferFilter;
use Mtc\Filter\Facades\Filter;

class FilterController extends Controller
{
    /**
     * Vehicle search filter endpoint
     *
     * @return array
     */
    public function index()
    {
        return Filter::handle();
    }

    /**
     * Vehicle search filter endpoint
     *
     * @return array
     */
    public function leaseVehicleIndex()
    {
        return LeaseVehicleFilter::handle();
    }

    /**
     * Vehicle search via widget
     *
     * @return array
     */
    public function widget()
    {
        return Filter::handleWidget();
    }

    /**
     * @param Request $request
     * @return array
     */
    public function filterStockAndOffers(): array
    {
        return StockAndOfferFilter::handle();
    }
}
