<?php

namespace Tests\Unit;

use App\Actions\Fortify\UpdateUserProfileInformation;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Validation\ValidationException;
use Mtc\MercuryDataModels\User;
use Tests\TestCase;

class UpdateUserProfileInformationTest extends TestCase
{
    use RefreshDatabase;
    /**
     * A basic unit test example.
     *
     * @return void
     */
    public function testUpdatesProfile()
    {
        $user = User::factory()->create();

        $input = [
            'name' => 'Peter Parker',
            'email' => 'john@example.com',
        ];

        (new UpdateUserProfileInformation())->update($user, $input);
        $user->refresh();
        $this->assertEquals('Peter Parker', $user->name);
        $this->assertEquals('john@example.com', $user->email);
    }

    public function testFailsWithIncompleteData()
    {
        $user = User::factory()->create();
        $input = [
            'email' => 'john@example.com',
        ];

        $this->expectException(ValidationException::class);
        (new UpdateUserProfileInformation())->update($user, $input);

        $user = User::factory()->create();
        $input = [
            'name' => 'Peter Parker',
        ];

        $this->expectException(ValidationException::class);
        (new UpdateUserProfileInformation())->update($user, $input);

    }

    public function testFailsWhenUserEmailExists()
    {
        User::factory()->create(['email' => 'john@example.com']);
        $user = User::factory()->create();

        $input = [
            'name' => 'Peter Parker',
            'email' => 'john@example.com',
        ];

        $this->expectException(ValidationException::class);
        (new UpdateUserProfileInformation())->update($user, $input);
    }
}
