<?php

namespace Tests\Tenant;

use App\VehicleSpec\Jobs\FetchVehicleSpecData;
use Database\Seeders\Tenant\VehicleSpecSeeder;
use Illuminate\Support\Facades\Queue;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class VehicleSpecControllerTest extends TenantTestCase
{
    use UserForTenant;

    public function testQueueSpecImportJob()
    {
        $this->seed(VehicleSpecSeeder::class);

        Queue::fake();

        $vehicle = Vehicle::factory()->create();

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.vehicles.get-spec', $vehicle));

        $response->assertStatus(200);

        Queue::assertPushed(FetchVehicleSpecData::class);
    }
}
