<?php

namespace Tests\Tenant;

use Database\Seeders\Tenant\SeoSettingSeeder;
use Mtc\MercuryDataModels\SeoDefault;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class SeoDefaultTest extends TenantTestCase
{
    use UserForTenant;

    public function testSeoSlugCheck()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.seo.check-slug'), [
                'type' => 'foo',
                'slug' => 'foo',
            ]);
        $response->assertStatus(422);

        $vehicle = Vehicle::factory()->create(['slug' => 'foo-baz-bar']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.seo.check-slug'), [
                'type' => 'vehicle',
                'slug' => 'foo-baz-bar',
                'id' => $vehicle->id,
            ]);

        $response->assertStatus(200);
        $this->assertFalse($response->json('used'));

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.seo.check-slug'), [
                'type' => 'vehicle',
                'slug' => 'foo-baz-bar',
            ]);

        $response->assertStatus(200);
        $this->assertTrue($response->json('used'));
    }
    public function testIndexPage()
    {
        $this->seed(SeoSettingSeeder::class);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.seo_settings.defaults.index'));

        $response->assertStatus(200);
        $this->assertCount(6, $response->json());
    }

    public function testUpdatePage()
    {
        $default = SeoDefault::factory()->create([
            'section' => 'page',
            'title' => '{{TITLE}} | {{SITE_NAME}}',
            'description' => '{{CONTENT_EXCERPT}}',
        ]);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->putJson(route('tenant.seo_settings.defaults.update', $default->id), [
                'title' => '{{TITLE}} - {{SITE_NAME}}',
                'description' => 'hello world'
            ]);

        $response->assertStatus(200);
        $default->refresh();
        $this->assertEquals('{{TITLE}} - {{SITE_NAME}}', $default->title);
        $this->assertEquals('hello world', $default->description);
    }

}
