<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\RunLabelAssignmentForVehiclesJob;
use Illuminate\Support\Facades\Queue;
use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\Label;
use Mtc\MercuryDataModels\LabelRule;
use Mtc\MercuryDataModels\TransmissionType;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleModel;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class RunLabelAssignmentForVehiclesJobTest extends TenantTestCase
{
    public function testJob()
    {
        $label = Label::factory()->create(['data' => ['auto_assign' => true]]);
        LabelRule::factory()->create([
            'label_id' => $label->id,
            'condition_field' => 'make_ids',
            'condition_value' => "[2]",
            'value_data_type' => 'json'
        ]);
        Settings::update('vehicle-labels-advanced-rules-enabled', true);
        Vehicle::factory(3)->create(['make_id' => 2]);
        Vehicle::factory(2)->create(['make_id' => 22]);

        (new RunLabelAssignmentForVehiclesJob($label))->handle();

        $this->assertEquals(3, $label->vehicles()->count());
    }

    public function testSkipsJobWhenNoAutoAssign()
    {
        $label = Label::factory()->create(['data' => ['auto_assign' => null]]);
        LabelRule::factory()->create([
            'label_id' => $label->id,
            'condition_field' => 'make_ids',
            'condition_value' => "[2]",
            'value_data_type' => 'json'
        ]);
        Settings::update('vehicle-labels-advanced-rules-enabled', true);
        Vehicle::factory(3)->create(['make_id' => 2]);
        Vehicle::factory(2)->create(['make_id' => 22]);

        (new RunLabelAssignmentForVehiclesJob($label))->handle();

        $this->assertEquals(0, $label->vehicles()->count());
    }
}
