<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Modules\Stock\KeyloopRev8;
use Database\Seeders\Tenant\KeyloopRev8SettingSeeder;
use Illuminate\Support\Facades\Queue;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class Rev8StockTest extends TenantTestCase
{

    public function testIsEnabled()
    {
        $this->seed(KeyloopRev8SettingSeeder::class);
        $this->assertFalse((new KeyloopRev8())->enabled());
        Settings::update('stock-keyloop-rev8-enabled', true);
        $this->assertTrue((new KeyloopRev8())->enabled());
    }

    public function testRunImport()
    {
        $this->seed(KeyloopRev8SettingSeeder::class);
        Queue::fake();
        Storage::fake('autonomy-ftp');

        Storage::disk('autonomy-ftp')->put('files/1.xlsx', file_get_contents(dirname(__DIR__) . '/data/rev8-stock.xlsx'));

        Settings::update('stock-keyloop-rev8-ftp-username', 'foo');
        Settings::update('stock-keyloop-rev8-ftp-username', 'pass');
        (new KeyloopRev8())->runScheduledImport();
        $this->assertEquals(5, Vehicle::query()->where('stock_provider', 'rev8-1')->count());
//        $this->assertFalse(Storage::disk('autonomy-ftp')->exists('files/1.xlsx'));
    }
}
