<?php

namespace Tests\Tenant;

use App\Events\TenantBroadcastEvent;
use App\NotificationRepository;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Event;
use Mtc\Notifications\Models\Notification;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class NotificationRepositoryTest extends TenantTestCase
{
    use UserForTenant;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testNotify()
    {
        /** @var NotificationRepository $repository */
        $repository = App::make(NotificationRepository::class);
        Event::fake();
        $repository->addNotification('error', 'foo', 'test', null, '/foo');
        Event::assertDispatched(TenantBroadcastEvent::class);

        $exists = Notification::query()
            ->where('severity', 'error')
            ->where('source', '/foo')
            ->where('message', 'foo')
            ->exists();

        $this->assertTrue($exists);
    }

}
