<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\CarzoneExportJob;
use App\Jobs\ChannelFeedExportJob;
use App\Jobs\EasiChatExportJob;
use App\Jobs\InventoryExportJob;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class InventoryExportTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('inventory-export');
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-inventory-file-name', 'foo.csv');

        (new InventoryExportJob())->handle();

        Storage::disk('inventory-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'inventory')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
