<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\CarzoneExportJob;
use App\Jobs\ChannelFeedExportJob;
use App\Jobs\EasiChatExportJob;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class EasiChatExportTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('file-storage');
        Vehicle::factory(10)->create();

        (new EasiChatExportJob())->handle();

        Storage::disk('file-storage')->assertExists('feeds/channel-feed/easichat_stock.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'easichat')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
