<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\CarzoneExportJob;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class CarzoneExportTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('carzone-export');
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-carzone-file-name', 'foo.csv');

        (new CarzoneExportJob())->handle();

        Storage::disk('carzone-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'carzone')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
