<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\CarsIrelandExportJob;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class CarsIrelandExportTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('cars-ireland-export');
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-cars-ireland-file-name', 'foo.csv');

        (new CarsIrelandExportJob())->handle();

        Storage::disk('cars-ireland-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'cars-ireland')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
