<?php

namespace Tests\Tenant;

use App\Master\Models\VehicleMake;
use Mtc\MercuryDataModels\CarConfiguratorExtra;
use Mtc\MercuryDataModels\Franchise;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class CarConfiguratorExtraControllerTest extends TenantTestCase
{
    use UserForTenant;

     /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testIndex()
    {
        CarConfiguratorExtra::factory(3)->create();

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.car-configurator-extras.index'));

        $response->assertStatus(200);
        $this->assertIsArray($response->json('data'));
        $this->assertCount(3, $response->json('data'));
    }

    public function testStore()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.car-configurator-extras.store'), [
                'name' => 'foo'
            ]);

        $response->assertStatus(201);
        $this->assertEquals('foo', $response->json('name'));
        $this->assertTrue(CarConfiguratorExtra::query()->where('name', 'foo')->exists());

    }

    public function testUpdate()
    {
        $extra = CarConfiguratorExtra::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->putJson(route('tenant.car-configurator-extras.update', $extra->id), [
                'name' => 'baz',
                'description' => 'lorem ipsum dolor',
                'price' => 123.00,
                'category' => 'foo faz',
            ]);

        $extra->refresh();
        $response->assertStatus(200);
        $this->assertEquals('baz', $extra->name);
        $this->assertEquals('lorem ipsum dolor', $extra->description);
        $this->assertEquals('foo faz', $extra->category);
        $this->assertEquals(123.00, $extra->price);

    }

    public function testShow()
    {
        $extra = CarConfiguratorExtra::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.car-configurator-extras.show', $extra->id));

        $response->assertStatus(200);
        $this->assertEquals($extra->id, $response->json('id'));
        $this->assertEquals('foo', $response->json('name'));

    }

    public function testDelete()
    {
        $extra = CarConfiguratorExtra::factory()->create(['name' => 'foo']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->deleteJson(route('tenant.car-configurator-extras.destroy', $extra->id));

        $response->assertStatus(200);
        $this->assertFalse(CarConfiguratorExtra::query()->where('id', $extra->id)->exists());
    }
}
