<?php

namespace Tests\Tenant;

use App\AdminSearchRepository;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class AdminSearchRepositoryTest extends TenantTestCase
{
    use UserForTenant;

    public function testVehicles()
    {
        $result = (new AdminSearchRepository())->getSectionFilters('vehicles');
        $this->assertCount(12, $result);
        $this->assertArrayHasKey('value', $result[0]);
        $this->assertArrayHasKey('name', $result[0]);
        $this->assertArrayHasKey('choices', $result[0]);
    }
    public function testCarConfigurator()
    {
        $result = (new AdminSearchRepository())->getSectionFilters('car-configurator');
        $this->assertCount(3, $result);
    }
    public function testValuations()
    {
        $result = (new AdminSearchRepository())->getSectionFilters('valuations');
        $this->assertCount(1, $result);
    }
    public function testOffers()
    {
        $result = (new AdminSearchRepository())->getSectionFilters('offers');
        $this->assertCount(11, $result);
    }
    public function testNewVehicles()
    {
        $result = (new AdminSearchRepository())->getSectionFilters('new-vehicles');
        $this->assertCount(8, $result);
    }
    public function testNewCars()
    {
        $result = (new AdminSearchRepository())->getSectionFilters('new-cars');
        $this->assertCount(8, $result);
    }
    public function testContent()
    {
        $result = (new AdminSearchRepository())->getSectionFilters('content');
        $this->assertCount(4, $result);
    }
    public function testPages()
    {
        $result = (new AdminSearchRepository())->getSectionFilters('pages');
        $this->assertCount(4, $result);
    }

    public function testFallback()
    {
        $result = (new AdminSearchRepository())->getSectionFilters('foo-faz-bar');
        $this->assertCount(0, $result);
    }

    public function testLeaseVehicles()
    {
        $result = (new AdminSearchRepository())->getSectionFilters('lease-vehicles');

        $this->assertCount(6, $result);
        $this->assertArrayHasKey('value', $result[0]);
        $this->assertArrayHasKey('name', $result[0]);
        $this->assertArrayHasKey('choices', $result[0]);
    }
}
