<?php

namespace Tests\Long;

use App\Facades\Settings;
use App\Services\CurrencyService;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Currency;
use Tests\TestCase;

/**
 * @group long
 */
class CurrencyServiceTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testPriceIsInSystemCurrency()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'foo',
            'group' => 'foo',
            'name' => 'foo',
            'config_key' => 'app-details-currency',
            'value' => 'EUR',
            'type' => 'string',
        ]);

        $this->assertEquals(123.22, (new CurrencyService())->convertToCurrency(123.22, 'EUR'));
    }

    public function testPriceIsNotInSystemCurrency()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'foo',
            'group' => 'foo',
            'name' => 'foo',
            'config_key' => 'app-details-currency',
            'value' => 'EUR',
            'type' => 'string',
        ]);
        Currency::factory()->create([
            'code' => 'GBP',
            'ratio' => 0.8
        ]);
        Currency::factory()->create([
            'code' => 'EUR',
            'ratio' => 1.0
        ]);

        $this->assertEquals(80, (new CurrencyService())->convertToCurrency(100, 'GBP'));
    }

    public function testPriceAndSystemIsNotEur()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'foo',
            'group' => 'foo',
            'name' => 'foo',
            'config_key' => 'app-details-currency',
            'value' => 'GBP',
            'type' => 'string',
        ]);
        Currency::factory()->create([
            'code' => 'GBP',
            'ratio' => 0.8
        ]);
        Currency::factory()->create([
            'code' => 'JPY',
            'ratio' => 0.1
        ]);
        Currency::factory()->create([
            'code' => 'EUR',
            'ratio' => 1.0
        ]);

        $this->assertEquals(8, (new CurrencyService())->convertToCurrency(100, 'JPY'));
    }
}
