<?php

namespace Tests\Long;

use App\Console\Commands\BackupCommand;
use App\Console\Commands\MakeUserAdmin;
use App\Console\Commands\SeedAdminUser;
use App\Console\Commands\SeedThemeData;
use App\Console\Commands\TenantsSyncTaxonomies;
use App\Master\Models\BodyStyleType;
use App\Master\Models\DrivetrainType;
use App\Master\Models\FuelType;
use App\Master\Models\TransmissionType;
use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use App\Models\Seed;
use App\Traits\TrackedSeeding;
use Database\Seeders\Tenant\BaseSettingSeeder;
use Database\Seeders\Tenant\CarWowExportSeeder;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Mtc\ContentManager\Models\ContentElement;
use Mtc\ContentManager\Models\Menu;
use Mtc\ContentManager\Models\Template;
use Mtc\MercuryDataModels\GlobalContent;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\Role;
use Mtc\MercuryDataModels\User;
use Tests\TestCase;
use Tests\UserForTenant;

/**
 * @group long
 */
class CommandTest extends TestCase
{
    use DatabaseMigrations;
    use UserForTenant;
    use TrackedSeeding;

    protected $tenancy = true;

    public function testTrackedSeed()
    {
        $this->artisan('tenants:seed')->assertExitCode(0);
        $this->assertTrue(Seed::query()->where('seeder', CarWowExportSeeder::class)->exists());
    }

    public function testDeploy()
    {
        $this->artisan('deploy')->assertExitCode(0);
        $this->assertTrue(Seed::query()->where('seeder', CarWowExportSeeder::class)->exists());
    }

    public function testClearModelsWithoutMakes()
    {
        $make = VehicleMake::factory()->create();
        VehicleModel::factory()->create(['make_id' => $make->id]);
        VehicleModel::factory()->create(['make_id' => 0]);

        $this->assertEquals(2, VehicleModel::query()->count());
        $this->artisan('clean:vehicle-models')->assertExitCode(0);
        $this->assertEquals(1, VehicleModel::query()->count());
    }

    public function testMakeUserAdmin()
    {
        Role::query()->create(['name' => 'mtc']);
        $user = User::factory()->create(['email' => 'foo@baz.com']);
        $this->artisan(MakeUserAdmin::class, ['email' => 'foo@baz.com'])
            ->assertExitCode(0);

        $user->hasRole('mtc');
    }

    public function testSeedAdminUser()
    {
        Role::query()->create(['name' => 'mtc']);
        $this->artisan(SeedAdminUser::class)
            ->expectsQuestion('Email:', 'foo@baz.com')
            ->expectsQuestion('Password: ', 'test123')
            ->assertExitCode(0);

        $this->assertTrue(User::query()->where('email', 'foo@baz.com')->exists());
        $user = User::query()->where('email', 'foo@baz.com')->first();
        $user->hasRole('mtc');
    }

    public function testSeedTheme()
    {
        $this->seed(BaseSettingSeeder::class);
        $this->artisan(SeedThemeData::class)->assertExitCode(0);
        $this->assertTrue(ContentElement::query()->exists());
        $this->assertTrue(GlobalContent::query()->exists());
        $this->assertTrue(Template::query()->exists());
        $this->assertTrue(Page::query()->exists());
        $this->assertTrue(Menu::query()->exists());
    }

    public function testTenantTaxonomySync()
    {
        VehicleMake::factory(10)->create();
        VehicleModel::factory(10)->create();
        FuelType::factory(10)->create();
        DrivetrainType::factory(10)->create();
        TransmissionType::factory(10)->create();
        BodyStyleType::factory(10)->create();
        $this->artisan(TenantsSyncTaxonomies::class)->assertExitCode(0);
    }
}
