<?php

namespace Tests\Feature\Controllers;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Storage;
use Mtc\ContentManager\Models\Media;
use Mtc\ContentManager\Models\MediaUse;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;
use Carbon\Carbon;
use Tests\TestCase;

class AutoImagingNotificationControllerTest extends TestCase
{
    use WithFaker;
    use RefreshDatabase;

    protected $tenancy = true;

    public function testNoAuthKey()
    {
        $this->withoutExceptionHandling();
        Config::set('services.image-sync.auto-imaging.key', 'abc');
        $response = $this->postJson(route('tenant.notifications.auto-imaging.store', tenant('id')), [
            'vehicleId' => 1
        ]);

        $response->assertStatus(401);
    }
}
