@extends('crm::emails.pck.layout-vehicle', [
   'subject' => $enquiry->subject ?? 'Thank you for your enquiry',
   'site_name' => $site_name,
   'site_logo' => $site_logo,
   'site_url' => $site_url,
   'colours' => $colours,
   'header_image' => "reservation-hero.png",
   'top_title' => 'Excited to Have You Onboard!',
   'description' => "One of our awesome PCK team members will be in touch soon to confirm the vehicle's availability and chat about the next steps."
])

@php
    $finance_url = \App\Facades\Site::url('thank-you/reservation') . '?' . http_build_query([
        'ImageUrl'  => $reservation?->vehicle?->getPreviewImage('900x675'),
        'Make'  => $reservation?->vehicle?->make?->name,
        'Model'  => $reservation?->vehicle?->model?->name,
        'Derivative'  => $reservation?->vehicle?->derivative,
        'Registration' => $reservation?->vehicle?->registration_number,
        'Colour' => $reservation?->vehicle?->colour,
        'Mileage' => $reservation?->vehicle?->odometer_mi,
        'FuelType' => $reservation?->vehicle?->fuelType?->name,
        'Transmission' => $reservation?->vehicle?->transmission?->name,
        'Year' =>$reservation?->vehicle?->manufacture_year,
        'RetailValue' => $reservation?->vehicle?->price,
    ]);
    $faq = [
        [
            "icon" => "car.png",
            "question" => "Can I view the car before finalising?",
            "answer" => "Definitely! We encourage you to come and see your dream car in person."
        ],
        [
            "icon" => "time.png",
            "question" => "How long does it take to get a finance quotation?",
            "answer" => "We always aim for a same working day quote."
        ],
        [
            "icon" => "car.png",
            "question" => "Is my finance check impact-free?",
            "answer" => "Yes, checking your finance eligibility with us won't affect your credit score."
        ],
        [
            "icon" => "check.png",
            "question" => "Do you accept part exchanges?",
            "answer" => "Yes! We take virtually any Part Exchange to help get you into your next car."
        ],
        [
            "icon" => "deposit.png",
            "question" => "Can I get my £99 deposit back if I cancel?",
            "answer" => "Absolutely! Requests made before 12pm (Mon-Fri) are refunded the same day."
        ]
    ];
@endphp

@section('content')
    <tr>
        <td valign="top" bgcolor="#242424" style="background-color:#242424">
            <table
                cellpadding="0"
                cellspacing="0"
                border="0"
                align="center"
                width="100%">

                @if ($reservation)
                    @include('crm::emails.pck.modules.details', ['details' => $reservation, 'enquiry' => false])
                @endif
                @include('crm::emails.pck.modules.text-block')
                @include('crm::emails.pck.modules.credit-check')
                @include('crm::emails.pck.modules.reviews')
                @include('crm::emails.pck.modules.contacts')
                @include('crm::emails.pck.modules.faq', ['enquiry' => false])
            </table>
        </td>
    </tr>
@endsection
