<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleSpecSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'CAP',
                'name' => 'CAP Vehicle Specs Enabled',
                'config_key' => 'vehicle-spec-providers-cap-enabled',
                'min_tier' => 'standard',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'CAP',
                'name' => 'CAP Subscriber ID',
                'config_key' => 'vehicle-spec-providers-cap-subscriber_id',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.vehicle-spec-providers-cap-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'CAP',
                'name' => 'CAP Password',
                'config_key' => 'vehicle-spec-providers-cap-password',
                'min_tier' => 'standard',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.vehicle-spec-providers-cap-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'CAP',
                'name' => 'Verify integration',
                'config_key' => 'vehicle-spec-providers-cap-verify',
                'min_tier' => 'standard',
                'type' => 'verify',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Retrieve specs/features for vehicles',
                'name' => 'Enabled',
                'config_key' => 'vehicle-spec-providers-autotrader-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Not required when stock pull from AutoTrader is used',
            ],

        ];
    }
}
