<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleSavingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'Peter Vardy Settings',
            'name' => 'PV Saving Mode Enabled',
            'config_key' => 'vehicle-savings-pv-mode-enabled',
            'type' => 'boolean',
            'value' => false,
            'superadmin' => true,
            'min_tier' => 'enterprise',
            'description' => 'Enable PV mode for vehicle savings.<br/>',
            'order' => 0,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'General',
            'name' => 'Previous Price Saving',
            'config_key' => 'vehicle-savings-enabled-previous-price',
            'type' => 'boolean',
            'value' => false,
            'superadmin' => true,
            'min_tier' => 'pro',
            'description' => 'Enable previous price saving.<br/>',
            'order' => 1,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'General',
            'name' => 'RRP Saving',
            'config_key' => 'vehicle-savings-enabled-rrp',
            'type' => 'boolean',
            'value' => false,
            'superadmin' => true,
            'min_tier' => 'pro',
            'description' => 'Enable RRP saving.<br/>',
            'order' => 1,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'Peter Vardy Settings',
            'name' => 'Finance Saving',
            'config_key' => 'vehicle-savings-enabled-finance-saving',
            'type' => 'boolean',
            'value' => false,
            'superadmin' => true,
            'min_tier' => 'enterprise',
            'description' => 'Enable finance saving.<br/>',
            'order' => 1,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'Peter Vardy Settings',
            'name' => 'Finance Contribution',
            'config_key' => 'vehicle-savings-enabled-finance-contribution',
            'type' => 'boolean',
            'value' => false,
            'superadmin' => true,
            'min_tier' => 'enterprise',
            'description' => 'Enable finance contribution.<br/>',
            'order' => 1,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'Peter Vardy Settings',
            'name' => 'Finance Saving: £ per £1000 of finance amount',
            'config_key' => 'vehicle-savings-pv-finance-saving-pounds-per-thousand',
            'type' => 'int',
            'value' => 25,
            'min_tier' => 'enterprise',
            'description' => 'Finance saving: Pounds per thousand of amount to be financed.<br/>',
            'order' => 1,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'Peter Vardy Settings',
            'name' => 'Finance Contribution ICE: % of finance amount',
            'config_key' => 'vehicle-savings-pv-finance-contribution-percent-ice',
            'type' => 'int',
            'value' => 2,
            'min_tier' => 'enterprise',
            'description' => 'Finance contribution: percentage of amount to finance for ICE vehicles.<br/>',
            'order' => 1,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'Peter Vardy Settings',
            'name' => 'Finance Contribution electric: % of finance amount',
            'config_key' => 'vehicle-savings-pv-finance-contribution-percent-electric',
            'type' => 'int',
            'value' => 5,
            'min_tier' => 'enterprise',
            'description' => 'Finance contribution: percentage of amount to finance for electric vehicles.<br/>',
            'order' => 1,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'Peter Vardy Settings',
            'name' => 'Finance Contribution max: ICE',
            'config_key' => 'vehicle-savings-pv-finance-contribution-max-ice',
            'type' => 'int',
            'value' => 600,
            'min_tier' => 'enterprise',
            'description' => 'Finance contribution: maximum saving for ICE vehicles.<br/>',
            'order' => 1,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'Peter Vardy Settings',
            'name' => 'Finance Contribution max: Electric',
            'config_key' => 'vehicle-savings-pv-finance-contribution-max-electric',
            'type' => 'int',
            'value' => 1000,
            'min_tier' => 'enterprise',
            'description' => 'Finance contribution: maximum saving for electric vehicles.<br/>',
            'order' => 1,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'General',
            'name' => 'Savings Type',
            'config_key' => 'vehicle-savings-type',
            'type' => 'string',
            'value' => '',
            'superadmin' => true,
            'min_tier' => 'pro',
            'description' => 'Set vehicle savings type.<br/>',
            'order' => 1,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'General',
            'name' => 'Enable Vehicle Saving',
            'config_key' => 'vehicle-savings-enabled',
            'type' => 'boolean',
            'value' => false,
            'min_tier' => 'pro',
            'description' => 'Enable the calculation and display of vehicle savings on the website.<br/>',
            'order' => 0,
        ]);

        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Vehicle Savings',
            'group' => 'General',
            'name' => 'Maximum Vehicle Saving',
            'config_key' => 'vehicle-savings-ceiling',
            'type' => 'int',
            'value' => 10000000,
            'min_tier' => 'pro',
            'description' => 'Vehicle savings will be capped at this value.<br/>',
            'order' => 1,
        ]);
    }
}
