<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleLabelAdvanceSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Use advanced label rules',
                'config_key' => 'vehicle-labels-advanced-rules-enabled',
                'type' => 'boolean',
                'value' => false,
                'min_tier' => 'pro',
                'description' => 'Use advanced rules for matching vehicle labels'
            ],
        ];
    }
}
