<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Mtc\ContentManager\Facades\Page as PageFacade;
use Mtc\ContentManager\Models\Template;
use Mtc\ContentManager\PageStatus;
use Mtc\MercuryDataModels\ContentElement;

class ValuationPageSeed extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->elements();
        $this->page($this->template());
    }

    private function elements()
    {
        if (app()->runningUnitTests()) {
            ContentElement::reguard();
        }
        collect($this->getElements())
            ->each(fn($entry) => ContentElement::query()->create($entry));

        // Now add all fields
        collect($this->getElements())
            ->filter(fn($entry) => !empty($entry['fields']))
            ->each(function ($entry) {
                /** @var ContentElement $element */
                $element = ContentElement::query()->where('slug', $entry['slug'])->first();
                collect($entry['fields'])
                    ->each(function ($field) use ($element) {
                        if (!empty($field['child_element_id'])) {
                            $field['child_element_id'] = ContentElement::query()
                                ->where('slug', $field['child_element_id'])
                                ->firstOrFail()
                                ->id;
                        }
                        $element->fields()->create($field);
                    });
            });
    }

    private function template()
    {

        if (app()->runningUnitTests()) {
            Template::reguard();
        }

        /** @var Template $template */
        $template = Template::query()->create([
            'name' => 'Valuation',
            'slug' => 'valuation',
            'status' => PageStatus::PUBLISHED->value,
        ]);

        $this->addTemplateElements($template);

        return $template->id;
    }

    private function page(int $template_id)
    {
        $page = PageFacade::create('Valuation', $template_id);
        $page->update([
            'slug' => 'valuation',
            'status' => PageStatus::PUBLISHED->value,
        ]);
    }

    private function getElements()
    {
        return [
            [
                'title' => 'Page Hero',
                'slug' => 'page-hero',
                'category' => 'content',
                'ui_component' => 'UiPageHero',
                'icon' => 'stars',
                'drag_and_drop' => 1,
                'data' => [
                    "order" => 0,
                    "nestable" => false,
                    "componentName" => false,
                    "component" => false,
                    "nestedLimit" => null,
                    "editable" => true,
                    "globalContent" => false,
                    "repeatable" => false,
                    "optionsMenuVisible" => false,
                    "isGroup" => true,
                    "error" => null
                ],
                'fields' => [
                    [
                        'field_type' => 'image',
                        'name' => 'Image',
                        'slug' => 'image',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "image",
                            "componentName" => "ImageUpload",
                            "component" => "EditableContentImageUpload",
                            'icon' => 'image',
                            'meta' => [
                                'options' => [
                                    'maxCount' => 1,
                                ]
                            ]
                        ],
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Title',
                        'slug' => 'title',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                ]
            ],
            [
                'title' => 'FAQ',
                'slug' => 'faq',
                'category' => 'supporting',
                'ui_component' => null,
                'icon' => null,
                'fields' => [
                    [
                        'field_type' => 'text',
                        'name' => 'Question',
                        'slug' => 'question',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Answer',
                        'slug' => 'answer',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                ]
            ],
            [
                'title' => 'FAQs',
                'slug' => 'faqs',
                'icon' => 'presentation-screen',
                'category' => 'content',
                'drag_and_drop' => 1,
                'ui_component' => 'UiFAQs',
                'fields' => [
                    [
                        'child_element_id' => 'faq',
                        'field_type' => 'element',
                        'slug' => 'faq',
                        'name' => 'Question',
                    ],
                ],
            ],
            [
                'title' => 'Form selection',
                'slug' => 'form',
                'icon' => 'question',
                'category' => 'content',
                'drag_and_drop' => 1,
                'ui_component' => 'UiForm',
                'fields' => [
                    [
                        'type' => 'form-field',
                        'field_type' => 'form-field',
                        "componentName" => "FormField",
                        "component" => "EditableContentFormField",
                        'slug' => 'form',
                        'name' => 'Select form',
                    ],
                ],
            ],
            [
                'title' => 'Icon + Text',
                'slug' => 'icon-and-text',
                'category' => 'supporting',
                'ui_component' => null,
                'icon' => null,
                'fields' => [
                    [
                        'field_type' => 'image',
                        'name' => 'Icon',
                        'slug' => 'icon',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "image",
                            "componentName" => "ImageUpload",
                            "component" => "EditableContentImageUpload",
                            'icon' => 'image',
                            'meta' => [
                                'options' => [
                                    'maxCount' => 1,
                                ]
                            ]
                        ],
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Text',
                        'slug' => 'text',
                        'data' => [
                            "nestable" => false,
                            "fieldId" => "text",
                            "componentName" => "TextField",
                            "component" => "EditableContentTextField",
                            'icon' => 'text',
                        ],
                    ],
                ]
            ],
            [
                'title' => 'Valuation steps',
                'slug' => 'faqs',
                'icon' => 'valuation-steps',
                'category' => 'content',
                'data' => [
                    'nestable' => true,
                    'nestedLimit' => 3,
                ],
                'fields' => [
                    [
                        'child_element_id' => 'icon-and-text',
                        'field_type' => 'element',
                        'slug' => 'icon-and-text',
                        'name' => 'Icon + text',
                    ],
                ],
            ],
        ];
    }

    private function addTemplateElements(Template $owner): void
    {
        collect([
            [
                'name' => 'Page Hero',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'page-hero')->first()?->id,
                'data' => [
                    'fieldId' => 'element',
                    'icon' => 'stars',
                    'nestable' => true,
                    'componentName' => false,
                    'nestedLimit' => 1,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],

            [
                'name' => 'Valuation steps',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'valuation-steps')->first()?->id,
                'data' => [
                    'fieldId' => 'element',
                    'icon' => 'presentation-screen',
                    'nestable' => true,
                    'componentName' => false,
                    'nestedLimit' => 3,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],

            [
                'name' => 'FAQs',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'faqs')->first()?->id,
                'data' => [
                    'fieldId' => 'element',
                    'icon' => 'question',
                    'nestable' => true,
                    'componentName' => false,
                    'nestedLimit' => 20,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],
            [
                'name' => 'Valuation Form',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'form')->first()?->id,
                'data' => [
                    'fieldId' => 'element',
                    'icon' => 'square',
                    'nestable' => true,
                    'componentName' => false,
                    'nestedLimit' => 1,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],
        ])
            ->each(function ($element) use ($owner) {
                $element['template_id'] = $owner->id;
                $owner->elements()->create($element);
            });

    }
}
