<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class UrlWwwSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->settings())
            ->each(fn($setting) => Settings::make($setting));

        Settings::delete('vehicles-url-path-include-www');
        Settings::delete('offers-url-path-include-www');
    }

    private function settings(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'General',
                'name' => 'Include www in page URL path',
                'config_key' => 'url-path-include-www',
                'type' => 'boolean',
                'value' => Settings::get('vehicles-url-path-include-www'),
            ]
        ];
    }
}
