<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Setting;

class UpdateAutosOnShowDescriptionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Setting::query()
            ->where('config_key', 'image-sync-autos-on-show-enabled')
            ->update([
                'description' => '<a href="https://www.autosonshow.com/" target="_blank">AutosOnShow</a> integration. '
                    . ' - retrieve images from AutosOnShow, handles notification when images have been updated/added.'
                    . ' When enabled, will grant access to URL for handling images:<br/>'
                    . route('tenant.notifications.autos-on-show', tenant('id')) . ' to receive and store images from AutosOnShow'
            ]);
    }
}
