<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class TimezoneSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Timezone',
                'config_key' => 'app-timezone',
                'type' => 'string',
                'value' => 'Europe/London',
                'choices' => collect(\DateTimeZone::listIdentifiers())
                    ->map(fn($identifier) => [
                        'value' => $identifier,
                        'name' => $identifier
                    ]),
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Different timezones for dealerships',
                'config_key' => 'app-dealership-timezone',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Enable this if dealerships are located on different timezones',
            ],

        ];
    }
}
