<?php

namespace Database\Seeders\Tenant;

use App\Master\Models\BodyStyleType;
use App\Master\Models\DrivetrainType;
use App\Master\Models\FuelType;
use App\Master\Models\TransmissionType;
use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\BodyStyleType as TenantBodyStyleType;
use Mtc\MercuryDataModels\DrivetrainType as TenantDrivetrainType;
use Mtc\MercuryDataModels\FuelType as TenantFuelType;
use Mtc\MercuryDataModels\TransmissionType as TenantTransmissionType;
use Mtc\MercuryDataModels\VehicleMake as TenantVehicleMake;
use Mtc\MercuryDataModels\VehicleModel as TenantVehicleModel;

class TaxonomySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        VehicleMake::all()
            ->each(fn($data) => TenantVehicleMake::query()->updateOrCreate(
                [ 'id' => $data->id ],
                [
                    'name' => $data->name,
                ]
            ));

        VehicleModel::all()
            ->each(fn($data) => TenantVehicleModel::query()->updateOrCreate(
                [ 'id' => $data->id ],
                [
                    'name' => $data->name,
                    'make_id' => $data->make_id,
                ]
            ));

        BodyStyleType::all()
            ->each(fn($data) => TenantBodyStyleType::query()->updateOrCreate(
                [ 'id' => $data->id ],
                [
                    'name' => $data->name,
                ]
            ));

        DrivetrainType::all()
            ->each(fn($data) => TenantDrivetrainType::query()->updateOrCreate(
                [ 'id' => $data->id ],
                [
                    'name' => $data->name,
                ]
            ));

        FuelType::all()
            ->each(fn($data) => TenantFuelType::query()->updateOrCreate(
                [ 'id' => $data->id ],
                [
                    'name' => $data->name,
                    'ev_data' => $data->ev_data,
                    'mpg_data' => $data->mpg_data,
                ]
            ));

        TransmissionType::all()
            ->each(fn($data) => TenantTransmissionType::query()->updateOrCreate(
                [ 'id' => $data->id ],
                [
                    'name' => $data->name,
                ]
            ));
    }

}
