<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class StripeSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Stripe',
                'name' => 'Enabled',
                'config_key' => 'sales-stripe-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Stripe',
                'name' => 'Public Key',
                'config_key' => 'sales-stripe-public_key',
                'type' => 'text',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-stripe-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Stripe',
                'name' => 'Private Key',
                'config_key' => 'sales-stripe-private_key',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-stripe-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Stripe',
                'name' => 'Reserve Price',
                'config_key' => 'sales-stripe-reserve_price',
                'type' => 'number',
                'value' => 99,
            ],
        ];
    }
}
