<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class   SimilarVehiclesSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Similar vehicles condition',
                'config_key' => 'vehicles-cross-sell-type',
                'type' => 'string',
                'value' => 'make-model',
                'description' => 'Condition to show similar vehicles',
                'choices' => [
                    ['value' => 'make-model', 'name' => 'Same make and model'],
                    ['value' => 'price-20', 'name' => 'Same price range (+/- 20%)'],
                    ['value' => 'body-type', 'name' => 'Same body type'],
                ],
                'order' => 7,
            ],
        ];
    }
}
