<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SalesforceCrmApiSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Enabled',
                'config_key' => 'salesforce-crm-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Username',
                'config_key' => 'salesforce-crm-username',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.salesforce-crm-enabled,true"
                ],
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Password',
                'config_key' => 'salesforce-crm-password',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.salesforce-crm-enabled,true"
                ],
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Client ID',
                'config_key' => 'salesforce-crm-client-id',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.salesforce-crm-enabled,true"
                ],
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Client Secret',
                'config_key' => 'salesforce-crm-client-secret',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.salesforce-crm-enabled,true"
                ],
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Send Reservations to Salesforce',
                'config_key' => 'salesforce-crm-send-reservations',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Feed Source',
                'config_key' => 'salesforce-crm-feedsource',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.salesforce-crm-enabled,true"
                ],
            ],
        ];
    }
}
