<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SalesForceNotificationSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        $description = 'SalesForce inbound vehicle notification integration. '
            . 'When enabled, will grant access to URL for updating vehicle data including price and availability: '
            . 'POST ' . route('tenant.notifications.sales-force.notify-vehicle', tenant('id'));

        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'SalesForce',
                'name' => 'Enable Inbound Notifications',
                'config_key' => 'sales-force-inbound-vehicle-notifications-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => $description,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'SalesForce',
                'name' => 'Bearer token',
                'config_key' => 'sales-force-inbound-vehicle-notifications-bearer-token',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:sales-force-inbound-vehicle-notifications-enabled,true"
                ]
            ],
        ];
    }
}
