<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ReservationRulePriceSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'General',
                'name' => 'Reserve Price (Motorcycle)',
                'config_key' => 'sales-reserve-price-motorcycle',
                'type' => 'number',
                'feature' => '!reservation-price-rules',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'General',
                'name' => 'Reserve Price (LCV)',
                'config_key' => 'sales-reserve_price_lcv',
                'type' => 'number',
                'feature' => '!reservation-price-rules',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'General',
                'name' => 'Reserve Price Rules',
                'config_key' => 'sales-reservation-price-config',
                'type' => 'component',
                'value' => 'SettingsReservationPriceConfig',
                'feature' => 'reservation-price-rules',
            ],
        ];
    }
}
