<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ReservationPriceSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'General',
                'name' => 'Reserve Price (General)',
                'config_key' => 'sales-reserve_price',
                'type' => 'number',
                'value' => 99,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'General',
                'name' => 'Reserve Price (LCV)',
                'config_key' => 'sales-reserve_price_lcv',
                'type' => 'number',
                'value' => 99,
            ],
        ];
    }
}
