<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class RegYearOverrideSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'General',
                'name' => 'Override registration year with model year',
                'config_key' => 'stock-override-reg-year-with-model-year',
                'type' => 'boolean',
                'value' => false,
                'description' => 'If VRM is AB71XYZ and manufacture year is 2022, set registration year to 2022 instead of 2021.',
            ],
        ];
    }
}
