<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PyxelVersionSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'Pyxel',
                'name' => 'Version ID',
                'config_key' => 'image-sync-pyxel-version-id',
                'type' => 'int',
                'value' => 1,
                'description' => 'Feed Version ID (VID) parameter.',
            ],
        ];
    }
}
