<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OffersDisableLookupSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Offers',
                'group' => 'Settings',
                'name' => 'Disable Lookup for Offers',
                'description' => 'When enabled, the vehicle data lookup workflow will be disabled when creating or editing offers. Make and model selection will use local database data instead of lookup providers.',
                'config_key' => 'offers-disable-lookup',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
