<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OfferNewOrderValueSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'New Offer Position',
                'config_key' => 'offers-new-offer-position',
                'description' => 'Define whether a newly created offer appears at the top or bottom of the list.',
                'type' => 'string',
                'choices' => [
                    ['name' => 'Beginning of list', 'value' => 'beginning'],
                    ['name' => 'End of list', 'value' => 'end'],
                ],
                'value' => 'end',
                'order' => 300
            ],
        ];
    }
}
