<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OfferFilterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Make',
                'config_key' => 'automotive-vehicle-filters-offer-make',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Model',
                'config_key' => 'automotive-vehicle-filters-offer-model',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Price Max',
                'config_key' => 'automotive-vehicle-filters-offer-price_max',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Price Min',
                'config_key' => 'automotive-vehicle-filters-offer-price_min',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Price Monthly Max',
                'config_key' => 'automotive-vehicle-filters-offer-price_monthly_max',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Price Monthly Min',
                'config_key' => 'automotive-vehicle-filters-offer-price_monthly_min',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Location',
                'config_key' => 'automotive-vehicle-filters-offer-location',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Colour',
                'config_key' => 'automotive-vehicle-filters-offer-colour',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Body Style',
                'config_key' => 'automotive-vehicle-filters-offer-body_type',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Fuel Type',
                'config_key' => 'automotive-vehicle-filters-offer-fuel_type',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Transmission Type',
                'config_key' => 'automotive-vehicle-filters-offer-transmission',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
