<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OccupopSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Occupop',
                'name' => 'Occupop enabled',
                'config_key' => 'jobs-occupop-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Enable Jobs Synchronization From
                    <a href="https://occupop.com/" target="_blank">Occupop</a>',
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Occupop',
                'name' => 'API Key',
                'config_key' => 'jobs-occupop-api_key',
                'type' => 'hidden',
                'value' => '',
                'description' => '',
                'validation_rules' => [
                    "required_if:values.jobs-occupop-enabled,true"
                ]
            ],
        ];
    }
}
