<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class NewsletterFormSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Newsletter',
                'group' => 'General',
                'name' => 'Form ID',
                'config_key' => 'newsletters-form-id',
                'type' => 'int',
                'min_tier' => 'standard',
                'value' => null,
                'description' => 'ID of the form to use for newsletter signup',
            ],
        ];
    }
}
