<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class NewCarLinkUrlSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'New Vehicles',
                'name' => 'New Vehicle page URL path',
                'config_key' => 'new-cars-url-path',
                'type' => 'string',
                'value' => '/new/{{SLUG}}',
                'order' => 1,
                'min_tier' => 'enterprise',
                'description' => 'path - e.g. /new/{{SLUG}} or /new/{{MAKE}}/{{MODEL}}/{{SLUG}} . '
                    . 'Supports MAKE MODEL FRANCHISE and SLUG placeholders. Used for URL generating in API, '
                    . 'must match the implementation in theme!',
            ],
        ];
    }
}
