<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class MotorsAdditionalSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motors',
                'name' => 'Exclude vehicles below price',
                'config_key' => 'stock-motors-sync-min-price',
                'type' => 'int',
                'min_tier' => 'standard',
                'value' => 0,
                'description' => 'Minimal price for vehicle to be imported',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motors',
                'name' => 'Max age (years) for vehicle',
                'config_key' => 'stock-motors-sync-max-age',
                'type' => 'int',
                'min_tier' => 'standard',
                'value' => 0,
                'description' => 'Max age for vehicle to be imported. 0 for no limit',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Motors',
                'name' => 'Max mileage for vehicle',
                'config_key' => 'stock-motors-sync-max-mileage',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => 0,
                'description' => 'Max mileage for vehicle to be imported. 0 for no limit',
            ],
        ];
    }
}
