<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class MotorCheckValuationSettingSeederAdjustment extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'MotorCheck',
                'name' => 'Valuation Driver',
                'config_key' => 'valuation-motor-check-driver',
                'type' => 'string',
                'min_tier' => 'pro',
                'choices' => [
                    [
                        'name' => 'AutoTrader',
                        'value' => 'auto-trader',
                    ],
                    [
                        'name' => 'VIP',
                        'value' => 'vip',
                    ],
                    [
                        'name' => 'Identity Lookup',
                        'value' => 'identity-lookup',
                    ],
                ],
            ],
        ];
    }
}
