<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class MotoNovoExportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Moto Novo',
                'name' => 'Enabled',
                'config_key' => 'sales-channels-moto-novo-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Moto Novo',
                'name' => 'FTP server Username',
                'config_key' => 'sales-channels-moto-novo-ftp-username',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-moto-novo-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Moto Novo',
                'name' => 'FTP server Password',
                'config_key' => 'sales-channels-moto-novo-ftp-password',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-moto-novo-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Moto Novo',
                'name' => 'Export file name',
                'config_key' => 'sales-channels-moto-novo-file-name',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-moto-novo-enabled,true"
                ]
            ],
        ];
    }
}
