<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class MediaUseExpirySettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'General',
                'name' => 'Unused media record expiry',
                'config_key' => 'app-old-media-use-expiry-days',
                'type' => 'int',
                'value' => 0,
                'superadmin' => true,
                'description' => '0 for system default. Any other value will overwrite tier based logic and will remove'
                    . ' unused media entries after specified number of days',
                'order' => 10,
            ],
        ];
    }
}
